-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               5.7.33 - MySQL Community Server (GPL)
-- Server OS:                    Win64
-- HeidiSQL Version:             11.2.0.6213
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table kinerja-pegawai.about_apps
CREATE TABLE IF NOT EXISTS `about_apps` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nama_singkat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nama_panjang` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `alamat` text COLLATE utf8mb4_unicode_ci,
  `telp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sosmed` json DEFAULT NULL,
  `maps` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.about_apps: ~0 rows (approximately)
/*!40000 ALTER TABLE `about_apps` DISABLE KEYS */;
INSERT INTO `about_apps` (`id`, `nama_singkat`, `nama_panjang`, `logo`, `icon`, `alamat`, `telp`, `email`, `sosmed`, `maps`, `created_at`, `updated_at`) VALUES
	(1, 'E-KIN PJLPBPP', 'E-KIN PJLPBPP', 'logo/01JMMFSE2ZGBJG5CP28KNK0QTT.png', 'icon/01JMMFSE3G7RGD0VCMZYSSDCGE.png', 'Jl. Contoh No. 123, Jakarta', '081234567890', 'info@myapp.com', '[{"url": "https://facebook.com/web.jasa", "platform": "Facebook"}, {"url": "https://instagram.com/web.jasa", "platform": "Instagram"}]', '-1.6734338034126812, 103.56819983524169', '2025-02-21 14:33:02', '2025-02-22 16:46:57');
/*!40000 ALTER TABLE `about_apps` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.absensis
CREATE TABLE IF NOT EXISTS `absensis` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shift_id` bigint(20) unsigned NOT NULL,
  `jenis_absen_id` bigint(20) unsigned NOT NULL,
  `uraian_jenis_absen_id` bigint(20) unsigned DEFAULT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `jam_datang` datetime DEFAULT NULL,
  `lokasi_datang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `jam_pulang` datetime DEFAULT NULL,
  `lokasi_pulang` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `absensis_shift_id_foreign` (`shift_id`),
  KEY `absensis_jenis_absen_id_foreign` (`jenis_absen_id`),
  KEY `absensis_user_id_foreign` (`user_id`),
  KEY `absensis_uraian_jenis_absen_id_foreign` (`uraian_jenis_absen_id`),
  CONSTRAINT `absensis_jenis_absen_id_foreign` FOREIGN KEY (`jenis_absen_id`) REFERENCES `jenis_absens` (`id`) ON DELETE CASCADE,
  CONSTRAINT `absensis_shift_id_foreign` FOREIGN KEY (`shift_id`) REFERENCES `shifts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `absensis_uraian_jenis_absen_id_foreign` FOREIGN KEY (`uraian_jenis_absen_id`) REFERENCES `uraian_jenis_absens` (`id`) ON DELETE SET NULL,
  CONSTRAINT `absensis_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.absensis: ~2 rows (approximately)
/*!40000 ALTER TABLE `absensis` DISABLE KEYS */;
INSERT INTO `absensis` (`id`, `shift_id`, `jenis_absen_id`, `uraian_jenis_absen_id`, `user_id`, `jam_datang`, `lokasi_datang`, `jam_pulang`, `lokasi_pulang`, `created_at`, `updated_at`) VALUES
	(30, 1, 1, 2, 2, '2025-02-23 01:16:25', '-1.6187392,103.5993088', '2025-02-23 01:25:06', '-1.6187392,103.5993088', '2025-02-23 01:16:25', '2025-02-23 01:25:06');
INSERT INTO `absensis` (`id`, `shift_id`, `jenis_absen_id`, `uraian_jenis_absen_id`, `user_id`, `jam_datang`, `lokasi_datang`, `jam_pulang`, `lokasi_pulang`, `created_at`, `updated_at`) VALUES
	(31, 1, 2, 4, 2, '2025-02-22 01:16:25', '-1.6187392,103.5993088', '2025-02-22 01:25:06', '-1.6187392,103.5993088', '2025-02-23 01:16:25', '2025-02-23 01:25:06');
INSERT INTO `absensis` (`id`, `shift_id`, `jenis_absen_id`, `uraian_jenis_absen_id`, `user_id`, `jam_datang`, `lokasi_datang`, `jam_pulang`, `lokasi_pulang`, `created_at`, `updated_at`) VALUES
	(32, 1, 1, NULL, 2, '2025-02-24 09:33:19', '-1.605632,103.5206656', NULL, NULL, '2025-03-24 09:33:19', '2025-02-24 09:33:19');
/*!40000 ALTER TABLE `absensis` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.bidangs
CREATE TABLE IF NOT EXISTS `bidangs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.bidangs: ~4 rows (approximately)
/*!40000 ALTER TABLE `bidangs` DISABLE KEYS */;
INSERT INTO `bidangs` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(1, 'Petugas Perhubungan - Jurumudi Kapal ', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `bidangs` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(2, 'Petugas Perhubungan - TEKNISI KAPAL', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `bidangs` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(3, 'Petugas Perhubungan - ANAK BUAH KAPAL', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `bidangs` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(4, 'Petugas Perhubungan - PETUGAS TATA KELOLA PELABUHAN', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
/*!40000 ALTER TABLE `bidangs` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.biodatas
CREATE TABLE IF NOT EXISTS `biodatas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `jk` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ttl` date NOT NULL,
  `nik` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alamat` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `no_hp` varchar(15) COLLATE utf8mb4_unicode_ci NOT NULL,
  `npwp` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `no_kontrak` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sertifikasi` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `biodatas_nik_unique` (`nik`),
  KEY `biodatas_user_id_foreign` (`user_id`),
  CONSTRAINT `biodatas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.biodatas: ~1 rows (approximately)
/*!40000 ALTER TABLE `biodatas` DISABLE KEYS */;
INSERT INTO `biodatas` (`id`, `user_id`, `jk`, `ttl`, `nik`, `alamat`, `no_hp`, `npwp`, `no_kontrak`, `sertifikasi`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Perempuan', '1990-05-20', '3201012005990001', 'Jl. Merdeka No. 123, Jakarta', '081234567890', '09.123.456.7-891.000', '2023/DISHUB/001', 'Sertifikasi Transportasi', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `biodatas` (`id`, `user_id`, `jk`, `ttl`, `nik`, `alamat`, `no_hp`, `npwp`, `no_kontrak`, `sertifikasi`, `created_at`, `updated_at`) VALUES
	(2, 2, 'Laki-laki', '2025-02-14', '1503101203950012', 'Jl.Jambi Simpang III Sipin Kota Baru Kota Jambi', '082180181958', '123123123123', '123123', 'asdsad', '2025-02-21 15:22:07', '2025-02-21 15:22:32');
/*!40000 ALTER TABLE `biodatas` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.breezy_sessions
CREATE TABLE IF NOT EXISTS `breezy_sessions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `authenticatable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `authenticatable_id` bigint(20) unsigned NOT NULL,
  `panel_id` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `guard` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `expires_at` timestamp NULL DEFAULT NULL,
  `two_factor_secret` text COLLATE utf8mb4_unicode_ci,
  `two_factor_recovery_codes` text COLLATE utf8mb4_unicode_ci,
  `two_factor_confirmed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `breezy_sessions_authenticatable_type_authenticatable_id_index` (`authenticatable_type`,`authenticatable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.breezy_sessions: ~0 rows (approximately)
/*!40000 ALTER TABLE `breezy_sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `breezy_sessions` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.cache
CREATE TABLE IF NOT EXISTS `cache` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.cache: ~3 rows (approximately)
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
INSERT INTO `cache` (`key`, `value`, `expiration`) VALUES
	('livewire-rate-limiter:a17961fa74e9275d529f489537f179c05d50c2f3', 'i:1;', 1740386058);
INSERT INTO `cache` (`key`, `value`, `expiration`) VALUES
	('livewire-rate-limiter:a17961fa74e9275d529f489537f179c05d50c2f3:timer', 'i:1740386058;', 1740386058);
INSERT INTO `cache` (`key`, `value`, `expiration`) VALUES
	('spatie.permission.cache', 'a:3:{s:5:"alias";a:4:{s:1:"a";s:2:"id";s:1:"b";s:4:"name";s:1:"c";s:10:"guard_name";s:1:"r";s:5:"roles";}s:11:"permissions";a:126:{i:0;a:4:{s:1:"a";i:1;s:1:"b";s:9:"view_role";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:1;a:4:{s:1:"a";i:2;s:1:"b";s:13:"view_any_role";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:2;a:4:{s:1:"a";i:3;s:1:"b";s:11:"create_role";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:3;a:4:{s:1:"a";i:4;s:1:"b";s:11:"update_role";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:4;a:4:{s:1:"a";i:5;s:1:"b";s:11:"delete_role";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:5;a:4:{s:1:"a";i:6;s:1:"b";s:15:"delete_any_role";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:6;a:4:{s:1:"a";i:7;s:1:"b";s:12:"view_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:7;a:4:{s:1:"a";i:8;s:1:"b";s:16:"view_any_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:8;a:4:{s:1:"a";i:9;s:1:"b";s:14:"create_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:9;a:4:{s:1:"a";i:10;s:1:"b";s:14:"update_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:10;a:4:{s:1:"a";i:11;s:1:"b";s:15:"restore_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:11;a:4:{s:1:"a";i:12;s:1:"b";s:19:"restore_any_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:12;a:4:{s:1:"a";i:13;s:1:"b";s:17:"replicate_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:13;a:4:{s:1:"a";i:14;s:1:"b";s:15:"reorder_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:14;a:4:{s:1:"a";i:15;s:1:"b";s:14:"delete_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:15;a:4:{s:1:"a";i:16;s:1:"b";s:18:"delete_any_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:16;a:4:{s:1:"a";i:17;s:1:"b";s:20:"force_delete_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:17;a:4:{s:1:"a";i:18;s:1:"b";s:24:"force_delete_any_absensi";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:18;a:4:{s:1:"a";i:19;s:1:"b";s:11:"view_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:19;a:4:{s:1:"a";i:20;s:1:"b";s:15:"view_any_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:20;a:4:{s:1:"a";i:21;s:1:"b";s:13:"create_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:21;a:4:{s:1:"a";i:22;s:1:"b";s:13:"update_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:22;a:4:{s:1:"a";i:23;s:1:"b";s:14:"restore_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:23;a:4:{s:1:"a";i:24;s:1:"b";s:18:"restore_any_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:24;a:4:{s:1:"a";i:25;s:1:"b";s:16:"replicate_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:25;a:4:{s:1:"a";i:26;s:1:"b";s:14:"reorder_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:26;a:4:{s:1:"a";i:27;s:1:"b";s:13:"delete_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:27;a:4:{s:1:"a";i:28;s:1:"b";s:17:"delete_any_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:28;a:4:{s:1:"a";i:29;s:1:"b";s:19:"force_delete_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:29;a:4:{s:1:"a";i:30;s:1:"b";s:23:"force_delete_any_bidang";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:30;a:4:{s:1:"a";i:31;s:1:"b";s:12:"view_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:31;a:4:{s:1:"a";i:32;s:1:"b";s:16:"view_any_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:32;a:4:{s:1:"a";i:33;s:1:"b";s:14:"create_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:33;a:4:{s:1:"a";i:34;s:1:"b";s:14:"update_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:34;a:4:{s:1:"a";i:35;s:1:"b";s:15:"restore_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:35;a:4:{s:1:"a";i:36;s:1:"b";s:19:"restore_any_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:36;a:4:{s:1:"a";i:37;s:1:"b";s:17:"replicate_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:37;a:4:{s:1:"a";i:38;s:1:"b";s:15:"reorder_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:38;a:4:{s:1:"a";i:39;s:1:"b";s:14:"delete_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:39;a:4:{s:1:"a";i:40;s:1:"b";s:18:"delete_any_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:40;a:4:{s:1:"a";i:41;s:1:"b";s:20:"force_delete_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:41;a:4:{s:1:"a";i:42;s:1:"b";s:24:"force_delete_any_biodata";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:42;a:4:{s:1:"a";i:43;s:1:"b";s:14:"view_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:43;a:4:{s:1:"a";i:44;s:1:"b";s:18:"view_any_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:44;a:4:{s:1:"a";i:45;s:1:"b";s:16:"create_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:45;a:4:{s:1:"a";i:46;s:1:"b";s:16:"update_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:46;a:4:{s:1:"a";i:47;s:1:"b";s:17:"restore_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:47;a:4:{s:1:"a";i:48;s:1:"b";s:21:"restore_any_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:48;a:4:{s:1:"a";i:49;s:1:"b";s:19:"replicate_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:49;a:4:{s:1:"a";i:50;s:1:"b";s:17:"reorder_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:50;a:4:{s:1:"a";i:51;s:1:"b";s:16:"delete_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:51;a:4:{s:1:"a";i:52;s:1:"b";s:20:"delete_any_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:52;a:4:{s:1:"a";i:53;s:1:"b";s:22:"force_delete_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:53;a:4:{s:1:"a";i:54;s:1:"b";s:26:"force_delete_any_informasi";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:54;a:4:{s:1:"a";i:55;s:1:"b";s:17:"view_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:55;a:4:{s:1:"a";i:56;s:1:"b";s:21:"view_any_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:56;a:4:{s:1:"a";i:57;s:1:"b";s:19:"create_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:57;a:4:{s:1:"a";i:58;s:1:"b";s:19:"update_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:58;a:4:{s:1:"a";i:59;s:1:"b";s:20:"restore_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:59;a:4:{s:1:"a";i:60;s:1:"b";s:24:"restore_any_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:60;a:4:{s:1:"a";i:61;s:1:"b";s:22:"replicate_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:61;a:4:{s:1:"a";i:62;s:1:"b";s:20:"reorder_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:62;a:4:{s:1:"a";i:63;s:1:"b";s:19:"delete_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:63;a:4:{s:1:"a";i:64;s:1:"b";s:23:"delete_any_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:64;a:4:{s:1:"a";i:65;s:1:"b";s:25:"force_delete_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:65;a:4:{s:1:"a";i:66;s:1:"b";s:29:"force_delete_any_jenis::absen";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:66;a:4:{s:1:"a";i:67;s:1:"b";s:17:"view_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:67;a:4:{s:1:"a";i:68;s:1:"b";s:21:"view_any_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:68;a:4:{s:1:"a";i:69;s:1:"b";s:19:"create_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:69;a:4:{s:1:"a";i:70;s:1:"b";s:19:"update_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:70;a:4:{s:1:"a";i:71;s:1:"b";s:20:"restore_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:71;a:4:{s:1:"a";i:72;s:1:"b";s:24:"restore_any_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:72;a:4:{s:1:"a";i:73;s:1:"b";s:22:"replicate_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:73;a:4:{s:1:"a";i:74;s:1:"b";s:20:"reorder_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:74;a:4:{s:1:"a";i:75;s:1:"b";s:19:"delete_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:75;a:4:{s:1:"a";i:76;s:1:"b";s:23:"delete_any_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:76;a:4:{s:1:"a";i:77;s:1:"b";s:25:"force_delete_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:77;a:4:{s:1:"a";i:78;s:1:"b";s:29:"force_delete_any_jenis::kerja";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:78;a:4:{s:1:"a";i:79;s:1:"b";s:12:"view_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:79;a:4:{s:1:"a";i:80;s:1:"b";s:16:"view_any_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:80;a:4:{s:1:"a";i:81;s:1:"b";s:14:"create_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:81;a:4:{s:1:"a";i:82;s:1:"b";s:14:"update_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:82;a:4:{s:1:"a";i:83;s:1:"b";s:15:"restore_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:83;a:4:{s:1:"a";i:84;s:1:"b";s:19:"restore_any_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:84;a:4:{s:1:"a";i:85;s:1:"b";s:17:"replicate_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:85;a:4:{s:1:"a";i:86;s:1:"b";s:15:"reorder_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:86;a:4:{s:1:"a";i:87;s:1:"b";s:14:"delete_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:87;a:4:{s:1:"a";i:88;s:1:"b";s:18:"delete_any_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:88;a:4:{s:1:"a";i:89;s:1:"b";s:20:"force_delete_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:89;a:4:{s:1:"a";i:90;s:1:"b";s:24:"force_delete_any_kinerja";s:1:"c";s:3:"web";s:1:"r";a:2:{i:0;i:1;i:1;i:2;}}i:90;a:4:{s:1:"a";i:91;s:1:"b";s:15:"view_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:91;a:4:{s:1:"a";i:92;s:1:"b";s:19:"view_any_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:92;a:4:{s:1:"a";i:93;s:1:"b";s:17:"create_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:93;a:4:{s:1:"a";i:94;s:1:"b";s:17:"update_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:94;a:4:{s:1:"a";i:95;s:1:"b";s:18:"restore_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:95;a:4:{s:1:"a";i:96;s:1:"b";s:22:"restore_any_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:96;a:4:{s:1:"a";i:97;s:1:"b";s:20:"replicate_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:97;a:4:{s:1:"a";i:98;s:1:"b";s:18:"reorder_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:98;a:4:{s:1:"a";i:99;s:1:"b";s:17:"delete_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:99;a:4:{s:1:"a";i:100;s:1:"b";s:21:"delete_any_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:100;a:4:{s:1:"a";i:101;s:1:"b";s:23:"force_delete_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:101;a:4:{s:1:"a";i:102;s:1:"b";s:27:"force_delete_any_set::shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:102;a:4:{s:1:"a";i:103;s:1:"b";s:10:"view_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:103;a:4:{s:1:"a";i:104;s:1:"b";s:14:"view_any_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:104;a:4:{s:1:"a";i:105;s:1:"b";s:12:"create_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:105;a:4:{s:1:"a";i:106;s:1:"b";s:12:"update_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:106;a:4:{s:1:"a";i:107;s:1:"b";s:13:"restore_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:107;a:4:{s:1:"a";i:108;s:1:"b";s:17:"restore_any_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:108;a:4:{s:1:"a";i:109;s:1:"b";s:15:"replicate_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:109;a:4:{s:1:"a";i:110;s:1:"b";s:13:"reorder_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:110;a:4:{s:1:"a";i:111;s:1:"b";s:12:"delete_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:111;a:4:{s:1:"a";i:112;s:1:"b";s:16:"delete_any_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:112;a:4:{s:1:"a";i:113;s:1:"b";s:18:"force_delete_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:113;a:4:{s:1:"a";i:114;s:1:"b";s:22:"force_delete_any_shift";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:114;a:4:{s:1:"a";i:115;s:1:"b";s:9:"view_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:115;a:4:{s:1:"a";i:116;s:1:"b";s:13:"view_any_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:116;a:4:{s:1:"a";i:117;s:1:"b";s:11:"create_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:117;a:4:{s:1:"a";i:118;s:1:"b";s:11:"update_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:118;a:4:{s:1:"a";i:119;s:1:"b";s:12:"restore_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:119;a:4:{s:1:"a";i:120;s:1:"b";s:16:"restore_any_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:120;a:4:{s:1:"a";i:121;s:1:"b";s:14:"replicate_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:121;a:4:{s:1:"a";i:122;s:1:"b";s:12:"reorder_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:122;a:4:{s:1:"a";i:123;s:1:"b";s:11:"delete_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:123;a:4:{s:1:"a";i:124;s:1:"b";s:15:"delete_any_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:124;a:4:{s:1:"a";i:125;s:1:"b";s:17:"force_delete_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}i:125;a:4:{s:1:"a";i:126;s:1:"b";s:21:"force_delete_any_user";s:1:"c";s:3:"web";s:1:"r";a:1:{i:0;i:1;}}}s:5:"roles";a:2:{i:0;a:3:{s:1:"a";i:1;s:1:"b";s:11:"super_admin";s:1:"c";s:3:"web";}i:1;a:3:{s:1:"a";i:2;s:1:"b";s:9:"validator";s:1:"c";s:3:"web";}}}', 1740627332);
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.cache_locks
CREATE TABLE IF NOT EXISTS `cache_locks` (
  `key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int(11) NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.cache_locks: ~0 rows (approximately)
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.failed_jobs
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.failed_jobs: ~0 rows (approximately)
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.informasis
CREATE TABLE IF NOT EXISTS `informasis` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `judul` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `deskripsi` text COLLATE utf8mb4_unicode_ci,
  `file` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.informasis: ~4 rows (approximately)
/*!40000 ALTER TABLE `informasis` DISABLE KEYS */;
INSERT INTO `informasis` (`id`, `judul`, `deskripsi`, `file`, `created_at`, `updated_at`) VALUES
	(1, 'Pengumuman Libur Nasional', 'Dinas Perhubungan mengumumkan libur nasional pada tanggal 25 Desember.', 'informasi/01JMCQYS27J2NX3Z6EXQE2D9HC.jpg', '2025-02-11 16:08:59', '2025-02-18 14:38:54');
INSERT INTO `informasis` (`id`, `judul`, `deskripsi`, `file`, `created_at`, `updated_at`) VALUES
	(2, 'Pelatihan Pegawai Baru', 'Pelatihan pegawai baru akan dilaksanakan pada awal bulan depan.', 'informasi/01JMCQYS27J2NX3Z6EXQE2D9HC.jpg', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `informasis` (`id`, `judul`, `deskripsi`, `file`, `created_at`, `updated_at`) VALUES
	(3, 'Pelatihan Pegawai Baru', 'Pelatihan pegawai baru akan dilaksanakan pada awal bulan depan.', 'informasi/01JMCQYS27J2NX3Z6EXQE2D9HC.jpg', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `informasis` (`id`, `judul`, `deskripsi`, `file`, `created_at`, `updated_at`) VALUES
	(4, 'Test Info', 'Pelatihan pegawai baru akan dilaksanakan pada awal bulan depan.', 'informasi/01JMPC2JQYBWZPQC8YVSRFBGEY.pdf', '2025-02-11 16:08:59', '2025-02-22 15:23:40');
/*!40000 ALTER TABLE `informasis` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.jenis_absens
CREATE TABLE IF NOT EXISTS `jenis_absens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `jenis_absens_nama_unique` (`nama`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.jenis_absens: ~7 rows (approximately)
/*!40000 ALTER TABLE `jenis_absens` DISABLE KEYS */;
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(1, 'Hadir', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(2, 'Cuti', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(3, 'Izin', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(4, 'Sakit', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(5, 'Dinas Luar', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(6, 'Pulang Cepat', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(7, 'Alpa', '2025-02-22 16:07:27', '2025-02-22 16:07:27');
INSERT INTO `jenis_absens` (`id`, `nama`, `created_at`, `updated_at`) VALUES
	(8, 'Terlambat', '2025-02-22 16:09:15', '2025-02-22 16:09:15');
/*!40000 ALTER TABLE `jenis_absens` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.jenis_kerjas
CREATE TABLE IF NOT EXISTS `jenis_kerjas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `bidang_id` bigint(20) unsigned NOT NULL,
  `uraian` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `jenis_kerjas_bidang_id_foreign` (`bidang_id`),
  CONSTRAINT `jenis_kerjas_bidang_id_foreign` FOREIGN KEY (`bidang_id`) REFERENCES `bidangs` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.jenis_kerjas: ~2 rows (approximately)
/*!40000 ALTER TABLE `jenis_kerjas` DISABLE KEYS */;
INSERT INTO `jenis_kerjas` (`id`, `bidang_id`, `uraian`, `created_at`, `updated_at`) VALUES
	(1, 1, '<p>Pengawasan Lalu Lintas</p>', '2025-02-11 16:08:59', '2025-02-18 14:50:51');
INSERT INTO `jenis_kerjas` (`id`, `bidang_id`, `uraian`, `created_at`, `updated_at`) VALUES
	(2, 1, 'Pemeriksaan Kendaraan', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
/*!40000 ALTER TABLE `jenis_kerjas` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.jobs
CREATE TABLE IF NOT EXISTS `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.jobs: ~0 rows (approximately)
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.job_batches
CREATE TABLE IF NOT EXISTS `job_batches` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` mediumtext COLLATE utf8mb4_unicode_ci,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.job_batches: ~0 rows (approximately)
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.kinerjas
CREATE TABLE IF NOT EXISTS `kinerjas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `tanggal` date NOT NULL,
  `jam_mulai` time NOT NULL,
  `jam_selesai` time NOT NULL,
  `jenis_kerja_id` bigint(20) unsigned NOT NULL,
  `aktivitas_lain` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keterangan` text COLLATE utf8mb4_unicode_ci,
  `bukti_foto` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `latitude` decimal(10,7) DEFAULT NULL,
  `longitude` decimal(10,7) DEFAULT NULL,
  `validator_id` bigint(20) unsigned DEFAULT NULL,
  `status_validasi` enum('pending','disetujui','ditolak') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `keterangan_validasi` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `kinerjas_user_id_foreign` (`user_id`),
  KEY `kinerjas_jenis_kerja_id_foreign` (`jenis_kerja_id`),
  KEY `kinerjas_validator_id_foreign` (`validator_id`),
  CONSTRAINT `kinerjas_jenis_kerja_id_foreign` FOREIGN KEY (`jenis_kerja_id`) REFERENCES `jenis_kerjas` (`id`) ON DELETE CASCADE,
  CONSTRAINT `kinerjas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE,
  CONSTRAINT `kinerjas_validator_id_foreign` FOREIGN KEY (`validator_id`) REFERENCES `users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.kinerjas: ~4 rows (approximately)
/*!40000 ALTER TABLE `kinerjas` DISABLE KEYS */;
INSERT INTO `kinerjas` (`id`, `user_id`, `tanggal`, `jam_mulai`, `jam_selesai`, `jenis_kerja_id`, `aktivitas_lain`, `keterangan`, `bukti_foto`, `latitude`, `longitude`, `validator_id`, `status_validasi`, `keterangan_validasi`, `created_at`, `updated_at`) VALUES
	(7, 2, '2025-02-22', '01:46:00', '07:46:00', 2, 'z', 'z', 'bukti_kinerja/aMY4e5Nr9mKpyLzTgGsBNLu2JeyrcqeVXRSXwhZg.png', -1.6187392, 103.5993088, 1, 'ditolak', 'v', '2025-02-22 01:47:03', '2025-02-22 01:47:03');
INSERT INTO `kinerjas` (`id`, `user_id`, `tanggal`, `jam_mulai`, `jam_selesai`, `jenis_kerja_id`, `aktivitas_lain`, `keterangan`, `bukti_foto`, `latitude`, `longitude`, `validator_id`, `status_validasi`, `keterangan_validasi`, `created_at`, `updated_at`) VALUES
	(8, 1, '2025-02-15', '01:57:00', '02:57:00', 2, 'asd', 'asd', 'bukti_kinerja/xu5Z5sMoCk4E17mUPvKQA3QZeXCOZbzFmZ2ZIKJC.png', -1.6187392, 103.5993088, 1, 'disetujui', 'a', '2025-02-22 01:57:22', '2025-02-22 01:57:22');
INSERT INTO `kinerjas` (`id`, `user_id`, `tanggal`, `jam_mulai`, `jam_selesai`, `jenis_kerja_id`, `aktivitas_lain`, `keterangan`, `bukti_foto`, `latitude`, `longitude`, `validator_id`, `status_validasi`, `keterangan_validasi`, `created_at`, `updated_at`) VALUES
	(9, 1, '2025-03-15', '01:59:00', '01:00:00', 2, 'z', 'z', 'bukti_kinerja/y0KNGxu2pp87ZFtO0RF5FvsiPyR0PV3Ca57hSqD1.png', -1.6187392, 103.5993088, 1, 'disetujui', 'c', '2025-02-22 01:57:38', '2025-02-22 01:57:38');
INSERT INTO `kinerjas` (`id`, `user_id`, `tanggal`, `jam_mulai`, `jam_selesai`, `jenis_kerja_id`, `aktivitas_lain`, `keterangan`, `bukti_foto`, `latitude`, `longitude`, `validator_id`, `status_validasi`, `keterangan_validasi`, `created_at`, `updated_at`) VALUES
	(10, 2, '2025-02-23', '01:59:00', '07:59:00', 2, 'z', 'z', 'bukti_kinerja/wo5l0Mbt1QNWse38lslEy6K7bw43BDVXOupcjtHf.jpg', -1.6187392, 103.5993088, 1, 'disetujui', 'b', '2025-02-23 01:59:40', '2025-02-23 01:59:40');
/*!40000 ALTER TABLE `kinerjas` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.migrations: ~17 rows (approximately)
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(1, '0001_01_01_000000_create_users_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(2, '0001_01_01_000001_create_cache_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(3, '0001_01_01_000002_create_jobs_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(4, '2025_02_11_141121_create_informasis_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(5, '2025_02_11_142326_create_bidangs_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(6, '2025_02_11_144528_add_bidang_id_and_username_to_users_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(7, '2025_02_11_145157_create_jenis_kerjas_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(8, '2025_02_11_145406_create_biodatas_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(9, '2025_02_11_145742_create_jenis_absens_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(10, '2025_02_11_150402_create_shifts_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(11, '2025_02_11_150601_create_set_shifts_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(12, '2025_02_11_160230_create_absensis_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(13, '2025_02_11_160453_create_kinerjas_table', 1);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(14, '2025_02_11_161955_create_breezy_sessions_table', 2);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(15, '2025_02_11_163140_add_avatar_url_column_to_users_table', 3);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(16, '2025_02_18_145420_add_nama_to_shifts_table', 4);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(18, '2025_02_20_164837_create_permission_tables', 5);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(19, '2025_02_21_143048_create_about_apps_table', 6);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(20, '2025_02_21_150218_add_field_to_biodatas_table', 7);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(21, '2025_02_23_005700_create_uraian_jenis_absens_table', 8);
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(22, '2025_02_23_005904_add_uraian_jenis_absen_id_to_absensis_table', 8);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.model_has_permissions
CREATE TABLE IF NOT EXISTS `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.model_has_permissions: ~0 rows (approximately)
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.model_has_roles
CREATE TABLE IF NOT EXISTS `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.model_has_roles: ~2 rows (approximately)
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
	(1, 'App\\Models\\User', 1);
INSERT INTO `model_has_roles` (`role_id`, `model_type`, `model_id`) VALUES
	(2, 'App\\Models\\User', 2);
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.password_reset_tokens
CREATE TABLE IF NOT EXISTS `password_reset_tokens` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.password_reset_tokens: ~0 rows (approximately)
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.permissions: ~126 rows (approximately)
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'view_role', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(2, 'view_any_role', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(3, 'create_role', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(4, 'update_role', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(5, 'delete_role', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(6, 'delete_any_role', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(7, 'view_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(8, 'view_any_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(9, 'create_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(10, 'update_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(11, 'restore_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(12, 'restore_any_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(13, 'replicate_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(14, 'reorder_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(15, 'delete_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(16, 'delete_any_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(17, 'force_delete_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(18, 'force_delete_any_absensi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(19, 'view_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(20, 'view_any_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(21, 'create_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(22, 'update_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(23, 'restore_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(24, 'restore_any_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(25, 'replicate_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(26, 'reorder_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(27, 'delete_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(28, 'delete_any_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(29, 'force_delete_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(30, 'force_delete_any_bidang', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(31, 'view_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(32, 'view_any_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(33, 'create_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(34, 'update_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(35, 'restore_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(36, 'restore_any_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(37, 'replicate_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(38, 'reorder_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(39, 'delete_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(40, 'delete_any_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(41, 'force_delete_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(42, 'force_delete_any_biodata', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(43, 'view_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(44, 'view_any_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(45, 'create_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(46, 'update_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(47, 'restore_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(48, 'restore_any_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(49, 'replicate_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(50, 'reorder_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(51, 'delete_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(52, 'delete_any_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(53, 'force_delete_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(54, 'force_delete_any_informasi', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(55, 'view_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(56, 'view_any_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(57, 'create_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(58, 'update_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(59, 'restore_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(60, 'restore_any_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(61, 'replicate_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(62, 'reorder_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(63, 'delete_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(64, 'delete_any_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(65, 'force_delete_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(66, 'force_delete_any_jenis::absen', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(67, 'view_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(68, 'view_any_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(69, 'create_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(70, 'update_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(71, 'restore_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(72, 'restore_any_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(73, 'replicate_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(74, 'reorder_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(75, 'delete_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(76, 'delete_any_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(77, 'force_delete_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(78, 'force_delete_any_jenis::kerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(79, 'view_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(80, 'view_any_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(81, 'create_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(82, 'update_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(83, 'restore_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(84, 'restore_any_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(85, 'replicate_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(86, 'reorder_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(87, 'delete_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(88, 'delete_any_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(89, 'force_delete_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(90, 'force_delete_any_kinerja', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(91, 'view_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(92, 'view_any_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(93, 'create_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(94, 'update_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(95, 'restore_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(96, 'restore_any_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(97, 'replicate_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(98, 'reorder_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(99, 'delete_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(100, 'delete_any_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(101, 'force_delete_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(102, 'force_delete_any_set::shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(103, 'view_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(104, 'view_any_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(105, 'create_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(106, 'update_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(107, 'restore_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(108, 'restore_any_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(109, 'replicate_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(110, 'reorder_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(111, 'delete_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(112, 'delete_any_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(113, 'force_delete_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(114, 'force_delete_any_shift', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(115, 'view_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(116, 'view_any_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(117, 'create_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(118, 'update_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(119, 'restore_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(120, 'restore_any_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(121, 'replicate_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(122, 'reorder_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(123, 'delete_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(124, 'delete_any_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(125, 'force_delete_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
INSERT INTO `permissions` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(126, 'force_delete_any_user', 'web', '2025-02-20 16:57:34', '2025-02-20 16:57:34');
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.roles: ~2 rows (approximately)
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(1, 'super_admin', 'web', '2025-02-20 16:55:52', '2025-02-20 16:55:52');
INSERT INTO `roles` (`id`, `name`, `guard_name`, `created_at`, `updated_at`) VALUES
	(2, 'validator', 'web', '2025-02-20 17:00:33', '2025-02-20 17:00:33');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.role_has_permissions
CREATE TABLE IF NOT EXISTS `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.role_has_permissions: ~150 rows (approximately)
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(1, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(2, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(3, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(4, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(5, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(6, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(7, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(8, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(9, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(10, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(11, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(12, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(13, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(14, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(15, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(16, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(17, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(18, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(19, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(20, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(21, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(22, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(23, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(24, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(25, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(26, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(27, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(28, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(29, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(30, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(31, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(32, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(33, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(34, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(35, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(36, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(37, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(38, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(39, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(40, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(41, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(42, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(43, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(44, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(45, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(46, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(47, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(48, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(49, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(50, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(51, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(52, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(53, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(54, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(55, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(56, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(57, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(58, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(59, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(60, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(61, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(62, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(63, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(64, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(65, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(66, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(67, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(68, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(69, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(70, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(71, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(72, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(73, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(74, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(75, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(76, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(77, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(78, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(79, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(80, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(81, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(82, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(83, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(84, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(85, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(86, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(87, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(88, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(89, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(90, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(91, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(92, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(93, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(94, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(95, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(96, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(97, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(98, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(99, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(100, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(101, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(102, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(103, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(104, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(105, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(106, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(107, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(108, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(109, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(110, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(111, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(112, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(113, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(114, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(115, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(116, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(117, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(118, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(119, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(120, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(121, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(122, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(123, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(124, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(125, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(126, 1);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(7, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(8, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(9, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(10, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(11, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(12, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(13, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(14, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(15, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(16, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(17, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(18, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(79, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(80, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(81, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(82, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(83, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(84, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(85, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(86, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(87, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(88, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(89, 2);
INSERT INTO `role_has_permissions` (`permission_id`, `role_id`) VALUES
	(90, 2);
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.sessions
CREATE TABLE IF NOT EXISTS `sessions` (
  `id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.sessions: ~3 rows (approximately)
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
	('DCYCA3xWSUg1gVsNIHpWuTkwalMuO4qtklsgIdtF', 2, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36', 'YTo0OntzOjY6Il90b2tlbiI7czo0MDoiTE1rb0RmbXJMUEhSV2wwc1ltaURnVmxZeEMxbG1uUkRiVmtycVRVaCI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NDE6Imh0dHA6Ly8xMjcuMC4wLjE6ODAwMC9tYWluL2tpbmVyamEvY3JlYXRlIjt9czo2OiJfZmxhc2giO2E6Mjp7czozOiJvbGQiO2E6MDp7fXM6MzoibmV3IjthOjA6e319czo1MDoibG9naW5fd2ViXzNkYzdhOTEzZWY1ZmQ0Yjg5MGVjYWJlMzQ4NzA4NTU3M2UxNmNmODIiO2k6Mjt9', 1740543531);
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
	('MOoCxN52mlGn6h6ydxfrH4YdgNguui9XGG4AaeZc', NULL, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36', 'YTo0OntzOjY6Il90b2tlbiI7czo0MDoiMHlYTHJnMXRMUmIzRE9Ec25JZTREVUg2djNEbEhsSjdUSXFybVhXNSI7czozOiJ1cmwiO2E6MTp7czo4OiJpbnRlbmRlZCI7czo1MjoiaHR0cDovL2tpbmVyamEtcGVnYXdhaS1sYXJhdmVsLnRlc3QvYWRtaW4vYWJvdXQtYXBwcyI7fXM6OToiX3ByZXZpb3VzIjthOjE6e3M6MzoidXJsIjtzOjQ3OiJodHRwOi8va2luZXJqYS1wZWdhd2FpLWxhcmF2ZWwudGVzdC9hZG1pbi9sb2dpbiI7fXM6NjoiX2ZsYXNoIjthOjI6e3M6Mzoib2xkIjthOjA6e31zOjM6Im5ldyI7YTowOnt9fX0=', 1740588928);
INSERT INTO `sessions` (`id`, `user_id`, `ip_address`, `user_agent`, `payload`, `last_activity`) VALUES
	('pKQkVT8V33LKw8srb4jjMY1rY3vJCuJZzIQDx0NU', 1, '127.0.0.1', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/133.0.0.0 Safari/537.36', 'YTo2OntzOjY6Il90b2tlbiI7czo0MDoiM2RLSjd6bWlJdFk1aGJ2WU1pUlp5UWFEb2d0cll4Q3VySGdlS3hMbiI7czo5OiJfcHJldmlvdXMiO2E6MTp7czozOiJ1cmwiO3M6NTI6Imh0dHA6Ly9raW5lcmphLXBlZ2F3YWktbGFyYXZlbC50ZXN0L2FkbWluL2Fib3V0LWFwcHMiO31zOjY6Il9mbGFzaCI7YToyOntzOjM6Im9sZCI7YTowOnt9czozOiJuZXciO2E6MDp7fX1zOjg6ImZpbGFtZW50IjthOjA6e31zOjUwOiJsb2dpbl93ZWJfM2RjN2E5MTNlZjVmZDRiODkwZWNhYmUzNDg3MDg1NTczZTE2Y2Y4MiI7aToxO3M6MTc6InBhc3N3b3JkX2hhc2hfd2ViIjtzOjYwOiIkMnkkMTIkL1Y2TkROMjZuVEYuQ2dZb2QyejJTdXE4TWk5Qk9RYUZnenNmSGpldFp0czRyakxOWlJKNTIiO30=', 1740549255);
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.set_shifts
CREATE TABLE IF NOT EXISTS `set_shifts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `shift_id` bigint(20) unsigned NOT NULL,
  `user_id` json DEFAULT NULL,
  `keterangan` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `set_shifts_shift_id_foreign` (`shift_id`),
  CONSTRAINT `set_shifts_shift_id_foreign` FOREIGN KEY (`shift_id`) REFERENCES `shifts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.set_shifts: ~2 rows (approximately)
/*!40000 ALTER TABLE `set_shifts` DISABLE KEYS */;
INSERT INTO `set_shifts` (`id`, `shift_id`, `user_id`, `keterangan`, `created_at`, `updated_at`) VALUES
	(1, 1, '["2", "1"]', 'Shift pagi untuk tim A', '2025-02-11 16:08:59', '2025-02-18 15:11:50');
INSERT INTO `set_shifts` (`id`, `shift_id`, `user_id`, `keterangan`, `created_at`, `updated_at`) VALUES
	(2, 2, '["1", "2"]', 'Shift sore untuk tim B', '2025-02-11 16:08:59', '2025-02-22 16:30:37');
/*!40000 ALTER TABLE `set_shifts` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.shifts
CREATE TABLE IF NOT EXISTS `shifts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `nama` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `datang` time NOT NULL,
  `pulang` time NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.shifts: ~3 rows (approximately)
/*!40000 ALTER TABLE `shifts` DISABLE KEYS */;
INSERT INTO `shifts` (`id`, `nama`, `datang`, `pulang`, `created_at`, `updated_at`) VALUES
	(1, 'Pagi', '08:00:00', '16:00:00', '2025-02-11 16:08:59', '2025-02-18 14:56:53');
INSERT INTO `shifts` (`id`, `nama`, `datang`, `pulang`, `created_at`, `updated_at`) VALUES
	(2, 'Siang', '16:00:00', '00:00:00', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `shifts` (`id`, `nama`, `datang`, `pulang`, `created_at`, `updated_at`) VALUES
	(3, 'Malam', '00:00:00', '08:00:00', '2025-02-11 16:08:59', '2025-02-11 16:08:59');
/*!40000 ALTER TABLE `shifts` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.uraian_jenis_absens
CREATE TABLE IF NOT EXISTS `uraian_jenis_absens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `jenis_absen_id` bigint(20) unsigned NOT NULL,
  `nama` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `uraian_jenis_absens_jenis_absen_id_foreign` (`jenis_absen_id`),
  CONSTRAINT `uraian_jenis_absens_jenis_absen_id_foreign` FOREIGN KEY (`jenis_absen_id`) REFERENCES `jenis_absens` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.uraian_jenis_absens: ~5 rows (approximately)
/*!40000 ALTER TABLE `uraian_jenis_absens` DISABLE KEYS */;
INSERT INTO `uraian_jenis_absens` (`id`, `jenis_absen_id`, `nama`, `created_at`, `updated_at`) VALUES
	(2, 1, 'Terlambat', NULL, NULL);
INSERT INTO `uraian_jenis_absens` (`id`, `jenis_absen_id`, `nama`, `created_at`, `updated_at`) VALUES
	(3, 2, 'Cuti Tahunan', NULL, NULL);
INSERT INTO `uraian_jenis_absens` (`id`, `jenis_absen_id`, `nama`, `created_at`, `updated_at`) VALUES
	(4, 2, 'Cuti Sakit', NULL, NULL);
INSERT INTO `uraian_jenis_absens` (`id`, `jenis_absen_id`, `nama`, `created_at`, `updated_at`) VALUES
	(5, 3, 'Izin Dinas Luar', NULL, NULL);
/*!40000 ALTER TABLE `uraian_jenis_absens` ENABLE KEYS */;

-- Dumping structure for table kinerja-pegawai.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `bidang_id` bigint(20) unsigned DEFAULT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`),
  KEY `users_bidang_id_foreign` (`bidang_id`),
  CONSTRAINT `users_bidang_id_foreign` FOREIGN KEY (`bidang_id`) REFERENCES `bidangs` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table kinerja-pegawai.users: ~12 rows (approximately)
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(1, 1, 'Admin Dishub', 'admin', 'admin@dishub.go.id', NULL, '$2y$12$/V6NDN26nTF.CgYod2z2Suq8Mi9BOQaFgzsfHjetZts4rjLNZRJ52', 'avatars/contoh foto 1.jpg', NULL, '2025-02-11 16:08:59', '2025-02-25 02:09:49');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(2, 1, 'Pegawai A', 'pegawai_a', 'pegawai_a@dishub.go.id', NULL, '$2y$12$uSeAMZGOF0iPAReip2TRcOWioOHO4DHvmC4Y2mb3D4DQilWjcyCUG', NULL, NULL, '2025-02-11 16:08:59', '2025-02-11 16:08:59');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(3, 1, 'OOS MAYDIANA MAKMUR', '80035826', '80035826@gmail.com', NULL, '$2y$12$FOvJoNAwwvZybz7aX/7APeC8yRBLMYImDSD.QnDyWMM7b5qOLZlvq', NULL, NULL, '2025-02-23 00:33:50', '2025-02-23 00:33:50');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(4, 2, 'MARVIN PRASETYO NUGROHO', '80034575', '80034575@gmail.com', NULL, '$2y$12$qvnqS8HOUz22jB3A231DnuzBSkGt2rZmXdL/tJu4GOPPXef6ysq5e', NULL, NULL, '2025-02-23 00:33:50', '2025-02-23 00:33:50');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(5, 3, 'SUPARDI', '80047084', '80047084@gmail.com', NULL, '$2y$12$fFiVtVe4Pr3wb2/e1JEB3en/vE2yjvZpUu4gncUPpAqvmRTlGntAa', NULL, NULL, '2025-02-23 00:33:50', '2025-02-23 00:33:50');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(6, 4, 'APRIANUS D.T.H', '80047069', '80047069@gmail.com', NULL, '$2y$12$KKJPn7HWCONhVnadOygFyulUP.4rUWex34LVaWwfdjBVuFadAPRNO', NULL, NULL, '2025-02-23 00:33:50', '2025-02-23 00:33:50');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(7, 1, 'SRI MULYANI', '80044150', '80044150@gmail.com', NULL, '$2y$12$HS9uFO9aEP4JhOC21GABb.8VlZMGUeHkdV6T5yBttbeErFGHWOovC', NULL, NULL, '2025-02-23 00:33:50', '2025-02-23 00:33:50');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(8, 2, 'TOMY ARMY M.P', '80345614', '80345614@gmail.com', NULL, '$2y$12$kaCoi3LkGw9BqXzOewSPr.ObZEj6vMvYVD0FimIBeJrjLoEDWoXc2', NULL, NULL, '2025-02-23 00:33:51', '2025-02-23 00:33:51');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(9, 3, 'M. RAIHAN PRADITAPUTRA', '80607009', '80607009@gmail.com', NULL, '$2y$12$vgGxBwiwHArxSvX2VaRHeug/gc6b8mRlzheAR8vwIZP4azRWQi1eG', NULL, NULL, '2025-02-23 00:33:51', '2025-02-23 00:33:51');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(10, 4, 'AGUNG UNTORO', '80012468', '80012468@gmail.com', NULL, '$2y$12$0TQxzUIaEWagvrGm3bt3qu8dEKdYny.31x5hWzs8gO.kIr7a4sg2S', NULL, NULL, '2025-02-23 00:33:51', '2025-02-23 00:33:51');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(11, 1, 'FARID PRASOJO', '80637455', '80637455@gmail.com', NULL, '$2y$12$cptrABswphNM83wqCEr41ePrOcccJ0gQZo7Z53Qbd6k7Z9BEpyPOm', NULL, NULL, '2025-02-23 00:33:51', '2025-02-23 00:33:51');
INSERT INTO `users` (`id`, `bidang_id`, `name`, `username`, `email`, `email_verified_at`, `password`, `avatar_url`, `remember_token`, `created_at`, `updated_at`) VALUES
	(12, 2, 'MIQDAD AL-GHIFFARY', '80637819', '80637819@gmail.com', NULL, '$2y$12$jNmp.zd21sOPAo5rmg1hYuk42z.dzV8rfxXF7jGuqS6DripIClv9i', NULL, NULL, '2025-02-23 00:33:51', '2025-02-23 00:33:51');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;

/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
